<?php

/**
 * @author Ultiminio Ramos
 * @since 2014-08-12
 */
class Magen4me_BanwireSpei_Model_Spei extends Mage_Payment_Model_Method_Abstract
{

    const BANWIRE_SPEI_MEDIA_FOLDER = 'banwire/spei/';
    const BANWIRE_SPEI_CODE = 'banwireSpei';
    const BANWIRE_SPEI_INFOBLOCKTYPE = 'banwireSpei/info_spei';
    const BANWIRE_SPEI_FORMBLOCKTYPE = 'banwireSpei/offline';
    const BANWIRE_SPEI_DIRLOG = '/Payment/Banwire/';
    const XML_PATH_BANWIRE_SPEI_EMAIL_TEMPLATE = 'payment/banwireSpei/email_template'; //payment_banwireSpei_email_template

    /**
     * $templateId can be set to numeric or string type value.
     * You can use Id of transactional emails (found in
     * "System->Trasactional Emails"). But better practice is
     * to create a config for this and use xml path to fetch
     * email template info (whatever from file/db).
     */

    /**
     * unique internal payment method identifier
     *
     * @var string [a-z0-9_]
     */
    protected $_code = self::BANWIRE_SPEI_CODE;
    protected $_infoBlockType = self::BANWIRE_SPEI_INFOBLOCKTYPE;
    protected $_formBlockType = self::BANWIRE_SPEI_FORMBLOCKTYPE;

    /**
     * Here are examples of flags that will determine functionality availability
     * of this module to be used by frontend and backend.
     *
     * @see all flags and their defaults in Mage_Payment_Model_Method_Abstract
     *
     * It is possible to have a custom dynamic logic by overloading
     * public function can* for each flag respectively
     */

    /**
     * Is this payment method a gateway (online auth/charge) ?
     */
    protected $_isGateway = true;

    /**
     * Can authorize online?
     */
    protected $_canAuthorize = true;

    /**
     * Can capture funds online?
     */
    protected $_canCapture = false;

    /**
     * Can capture partial amounts online?
     */
    protected $_canCapturePartial = false;

    /**
     * Can refund online?
     */
    protected $_canRefund = false;

    /**
     * Can void transactions online?
     */
    protected $_canVoid = true;

    /**
     * Can use this payment method in administration panel?
     */
    protected $_canUseInternal = true;

    /**
     * Can show this payment method as an option on checkout payment page?
     */
    protected $_canUseCheckout = true;

    /**
     * Is this payment method suitable for multi-shipping checkout?
     */
    protected $_canUseForMultishipping = true;

    /**
     * URL del webservice
     *
     * @var string
     */
    //private $_hostTesting = 'https://www.banwire.com/qa/api/1/payment/spei';
    private $_hostTesting = 'https://test.banwire.com/api/1/payment/spei';
    private $_hostProduct = 'https://www.banwire.com/api/1/payment/spei';
    private $_urlRequest = '';

    /**
     * Usuario para conectarse a la API de Banwire/SPEI-Fast.
     *
     * @var string
     */
    private $_user = 'userdemo';

    /**
     * URL para cachar la respuesta de Banwire.
     *
     * @var string
     */
    private $_urlResponse = 'https://{{your domain}}/banwire_UFC3920/spei/ipn.php';
    private $_sendSeparateStub = 0;

    /**
     * Si se debe guardar el registro de eventos en un archivo log.
     *
     * @var int
     */
    private $_bitacoras = 1;
    private $_dirLog = '';

    /**
     * Array contenedor de parametros para la API.
     *
     * @var array
     */
    private $_params = array(
        'user' => NULL, // Nombre del usuario en BanWire. string
        'ord_id' => NULL, // Número de orden. string 1-20
        'ord_amount' => NULL, // Monto de la transacción. float 1-12
        'ord_concept' => NULL, // Descripción de la transacción. string 5-100
        'notify_url' => NULL, // URL a donde se notificará cuando el pago ha sido realizado. string 1-255
        'customer' => array(
            'user_id' => NULL, // Identificador del cliente en el sistema origen. string 1-16
            'name' => NULL, // Nombre del cliente. string 10-50
            'cust_name' => NULL, // Nombre del cliente. string 10-50
            'phone' => NULL, // El número de teléfono del cliente. string 5-19
            'email' => NULL, // Correo electrónico del cliente. string 5-60
            'ip' => NULL, // Dirección ip del cliente. string
        ), // Hash con la información del cliente.
        'items' => array(
            'quantity' => NULL, // Cantidad de elementos de cada artículo. int 1-8
            'cst_amt' => NULL, // Precio único del artículo. float 1-10
            'amt' => NULL, // Monto total por artículo. float 1-10
            'desc' => NULL, // Descripción del artículo. string 1-127
        ), // Array de artículos asociados a la transacción.
    );

    /**
     * Contenedor de la respuesta, si procesas, de la API.
     *
     * @var string
     */
    private $_buffer = '';

    /**
     * Almacenar el increment Id para que posteriormente sirva como nombre de la imagen de Código de Barras.
     *
     * @var string
     */
    private $_incrementId = '000000000';

    /**
     * El tipo de datos para requests y responses.
     *
     * @var string
     */
    private $_dataFormat = 'JSON';

    /**
     * Nombre del consumidor
     *
     * @var string
     */
    private $_customerName = '';

    /**
     * Email del consumidor
     *
     * @var string
     */
    private $_customerEmail = '';

    /**
     * Contenedor de la respuesta, procesada, de la API.
     *
     * @var array
     */
    private $_response = array();

    /**
     * Here you will need to implement authorize, capture and void public methods
     *
     * @see examples of transaction specific public methods such as
     * authorize, capture and void in Mage_Paygate_Model_Authorizenet
     */

    /**
     * Send authorize request to gateway
     *
     * @param  Mage_Payment_Model_Info $payment
     * @param  decimal $amount
     * @return Mage_Paygate_Model_Authorizenet
     */
    public function authorize(Varien_Object $payment, $amount)
    {
        #Mage::throwException(Mage::helper('paygate')->__('Invalid amount for authorization.'));

        if ($amount <= 0) {
            Mage::throwException(Mage::helper('paygate')->__('Invalid amount for authorization.'));
        }

        $this->__init($payment);

        if (FALSE === $this->_postRequest($payment, $amount)) {
            Mage::throwException(Mage::helper('paygate')->__('Error: [' . $this->_response['code'] . ' - ' . $this->_response['parameter'] . '] ' . $this->_response['message']));
        } else {
            # Grabar la información regresada por Banwire/SPEI
            $payment->setAdditional_information(serialize($this->_response));
            $payment->setTransactionId($this->_response['clabe']);
            $payment->setIsTransactionClosed(0);
            $payment->setTransactionAdditionalInfo(Mage_Sales_Model_Order_Payment_Transaction::RAW_DETAILS, array(
                'ID' => $this->_response['clabe']
                , 'clabe' => $this->_response['clabe']
                , 'reference' => isset($this->_response['reference'])
                    //, 'due_date' => $this->_response['due_date']
            ));
            $payment->setIsTransactionPending(false);

            $this->sendComprobante($payment);
        }

        return $this;
    }

    /**
     * Post request to gateway and return response
     *
     * @param Mage_Paygate_Model_Authorizenet_Request $request)
     * @return Mage_Paygate_Model_Authorizenet_Result
     */
    protected function _postRequest($payment, $amount)
    {
        try {
            $this->_params['user'] = $this->_user;
            $this->_params['ord_id'] = $this->_incrementId;
            $this->_params['ord_amount'] = (float) $amount;
            $this->_params['ord_concept'] = str_replace('{{store_name}}', Mage::getStoreConfig('general/store_information/name') . ' ' . Mage::app()->getStore()->getName(), Mage::getStoreConfig('payment/banwireSpei/ord_concept'));
            $this->_params['notify_url'] = $this->_urlResponse;

            # determinar si la compra se está haciendo desde el backend
            $adminSession = Mage::getSingleton('admin/session');
            $adminLoggedIn = $adminSession->isLoggedIn();
            if ($adminLoggedIn) {
                $quote = Mage::getSingleton('adminhtml/session_quote')->getQuote();
            } else {
                $quote = Mage::getSingleton('checkout/session')->getQuote();
            }

            # obtener los objetos principales del proceso de compra
            $billingAddress = $quote->getBillingAddress();
            //$shippingAddress = $quote->getShippingAddress();

            # si al momento de hacer la compra, se está logueado en el sistema
            if (Mage::getSingleton('customer/session')->isLoggedIn()) {
                $customer = Mage::getSingleton('customer/session')->getCustomer();
                $this->_params['customer']['user_id'] = substr('0000000000000000' . trim((string) $customer->getId()), -16, 16);
                $this->_params['customer']['name'] = $customer->getName();
                $this->_params['customer']['cust_name'] = $customer->getName();
                $this->_params['customer']['email'] = $customer->getEmail();
            } else {
                # si no se está logueado
                $this->_params['customer']['user_id'] = '9000000000000000';
                $this->_params['customer']['name'] = $billingAddress->getName();
                $this->_params['customer']['cust_name'] = $billingAddress->getName();
                $this->_params['customer']['email'] = $billingAddress->getEmail();
            }

            # Obtener el teléfono del cliente
            $this->_params['customer']['phone'] = $this->_getTelefonoCliente($quote);
            $this->_params['customer']['ip'] = Mage::helper('core/http')->getRemoteAddr(FALSE);

            # obtener los items de la compra
            $this->_getArticulos();

            # enviar la petición
            $send = $this->send();

            if ($send) {
                if (1 == $this->_bitacoras) {
                    $contenido = print_r($this->_params, TRUE);
                    file_put_contents($this->_dirLog . 'Banwire_SPEI.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
                }

                return TRUE;
            } else {
                $contenido = print_r($this->_params, TRUE);
                file_put_contents($this->_dirLog . 'Banwire_SPEI_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);

                return FALSE;
            }
        } catch (Exception $e) {
            $contenido = $e;
            file_put_contents($this->_dirLog . 'Banwire_SPEI_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
            return FALSE;
        }
    }

    /**
     * Funcion constructora.
     *
     * @param Object $payment.
     */
    public function __init($payment)
    {
        if (1 == (int) Mage::getStoreConfig('payment/banwireSpei/debug_mode')) {
            $this->_urlRequest = $this->_hostTesting;
        } else {
            $this->_urlRequest = $this->_hostProduct;
        }
        $this->_user = Mage::getStoreConfig('payment/banwireSpei/merchant_id');
        $this->_urlResponse = Mage::getStoreConfig('payment/banwireSpei/catch_response');
        $this->_bitacoras = (int) Mage::getStoreConfig('payment/banwireSpei/bitacoras');
        $this->_dirLog = Mage::getBaseDir('log') . self::BANWIRE_SPEI_DIRLOG;
        $this->_sendSeparateStub = 0 == (int) Mage::getStoreConfig('payment/banwireSpei/separate_stub') ? FALSE : TRUE;

        # si al momento de hacer la compra, se está logueado en el sistema
        if (Mage::getSingleton('customer/session')->isLoggedIn()) {
            # Objeto customer
            $session = Mage::getSingleton('customer/session');
            $customer = $session->getCustomer();
            $this->_customerEmail = $customer->getEmail();
            $this->_customerName = $customer->getName();
        } else {
            # si no se está logueado
            $quote = Mage::getSingleton('checkout/session')->getQuote();
            $billingAddress = $quote->getBillingAddress();

            $this->_customerEmail = $billingAddress->getEmail();
            $this->_customerName = $billingAddress->getName();
        }

        # Objeto store
        //$storeId = (int) Mage::app()->getStore()->getId();
        ;

        /*
          Mage::log(__LINE__ . ': ' . __FILE__, 7, 'mylogfile.log');
          Mage::log('Store Id = ' . (string) $storeId, 7, 'mylogfile.log');
         */

        $order = $payment->getOrder();
        $incrementId = $order->getIncrementId();

        $this->_incrementId = empty($incrementId) ? $this->_incrementId : $incrementId;

        return $this;
    }

    /**
     * Envía las variables al servidor de BanWire mediante
     * metodo POST usando cURL y procesa la respuesta.
     *
     */
    public function send()
    {
        $postfields = $this->_params;
        if (!function_exists('curl_init')) {
            return FALSE;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->_urlRequest);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; WINDOWS; .NET CLR 1.1.4322)');
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postfields));
        if (defined('CURLOPT_ENCODING')) {
            curl_setopt($ch, CURLOPT_ENCODING, "");
        }

        if (1 == $this->_bitacoras) {
            $tmpx = print_r(json_encode($postfields), TRUE);
            $contenido = $this->_urlRequest . "\n" . $tmpx;
            file_put_contents($this->_dirLog . 'Banwire_SPEI_Request.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        $this->_buffer = curl_exec($ch); // Almacenamos resultado

        if ($this->_buffer == null)
            return FALSE;
        if (!defined('CURLOPT_ENCODING'))
            return FALSE;
        curl_close($ch);

        return $this->_parseResponse();
    }

    /**
     * Procesa la respuesta de la API.
     *
     * @param string $buffer Respuesta de la API.
     */
    private function _parseResponse($buffer = '')
    {
        if (empty($buffer)) {
            $buffer = $this->_buffer;
        }
        if (empty($buffer)) {
            return FALSE;
        }
        $this->_response = json_decode($buffer, TRUE);
        if ($this->_validateTransaction()) { // Transacción valida.
            if (1 == $this->_bitacoras) {
                $contenido = print_r($this->_response, TRUE);
                file_put_contents($this->_dirLog . 'Banwire_SPEI_Response.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
                $this->_response['reference'] = isset($this->_response['reference']) ? $this->_response['reference'] : $this->_incrementId;
            }

            return TRUE;
        } else { // Error en la transacción.
            $contenido = print_r($this->_response, TRUE);
            file_put_contents($this->_dirLog . 'Banwire_SPEI_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
            return FALSE;
        }
    }

    /**
     * Valida que la transaccion haya sido exitosa.
     *
     * @return boolean.
     */
    private function _validateTransaction()
    {
        if (empty($this->_response)) {
            return FALSE;
        }

        if (isset($this->_response['code'])) {
            return FALSE;
        }
        return TRUE;
    }

    /**
     * Obtiene la respuesta procesada de la API.
     *
     * @return array
     */
    public function getResponse()
    {
        return $this->_response; //($this->_response['error']) ? $this->_response : $this->_response;
    }

    public function getError()
    {
        return ($this->_response['code']) ? $this->_response['message'] : FALSE;
    }

    /**
     * Envía el talón de pago al consumidor.
     */
    public function sendComprobante($payment)
    {
        $templateId = Mage::getStoreConfig(self::XML_PATH_BANWIRE_SPEI_EMAIL_TEMPLATE);
        if (1 == $this->_bitacoras) {
            $contenido = $templateId;
            file_put_contents($this->_dirLog . 'Banwire_SPEI_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        $mailSubject = 'Tu talón de pago del pedido Num. ' . $payment->getOrderId();

        /**
         * $sender can be of type string or array. You can set identity of
         * diffrent Store emails (like 'support', 'sales', etc.) found
         * in "System->Configuration->General->Store Email Addresses"
         */
        $senderName = Mage::getStoreConfig('trans_email/ident_sales/name');
        $senderEmail = Mage::getStoreConfig('trans_email/ident_sales/email');
        $sender = array(
            'name' => $senderName,
            'email' => $senderEmail
        );
        if (1 == $this->_bitacoras) {
            $contenido = print_r($sender, TRUE);
            file_put_contents($this->_dirLog . 'Banwire_SPEI_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        /**
         * In case of multiple recipient use array here.
         */
        // Set recepient information
        $recepientEmail = $this->_customerEmail;
        $recepientName = $this->_customerName;

        // Get Store ID    
        $storeId = Mage::app()->getStore()->getId();

        // Set variables that can be used in email template
        $order = $payment->getOrder();

        $vars = array(
            'clabe' => $this->_response['clabe']
            , 'reference' => $this->_response['reference']
            //, 'due_date' => $this->_response['due_date']
            , 'spei_monto' => '$' . number_format($this->_params['ord_amount'], 2, '.', '.')
            , 'logo_banwspeifast' => Mage::getBaseUrl('media') . self::BANWIRE_SPEI_MEDIA_FOLDER . 'speifast.jpg'
            , 'incrementId' => $this->_incrementId
            , 'order' => $order
            , 'transaction' => $this->_params
            , 'isSpei' => 'true'
        );

        if (1 == $this->_bitacoras) {
            $contenido = print_r($vars['transaction'], TRUE);
            file_put_contents($this->_dirLog . 'Banwire_SPEI_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        /* Evitar el envío del talón de pago por separado */
        if (TRUE === $this->_sendSeparateStub) {
            $translate = Mage::getSingleton('core/translate');

            // Send Transactional Email
            Mage::getModel('core/email_template')
                    ->setTemplateSubject($mailSubject)
                    ->sendTransactional($templateId, $sender, $recepientEmail, $recepientName, $vars, $storeId)
            ;

            $translate->setTranslateInline(true);
        }
        /* */

        $this->generarTalonPago($order, $vars);
    }

    protected function generarTalonPago(& $order, & $vars)
    {
        $talon = file_get_contents(__DIR__ . '/talonSpei.html');
        if (1 == $this->_bitacoras) {
            $contenido = $talon;
            file_put_contents($this->_dirLog . 'Banwire_SPEI_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        $campos = array(
            'order_number' => $this->_incrementId
            , 'customer_name' => $this->_customerName
            , 'store_name' => Mage::getStoreConfig('general/store_information/name')
            , 'store_url' => Mage::getBaseUrl()
            , 'logo_banwire_spei' => $vars['logo_banwspeifast']
            , 'logo_email' => $_logoUrl = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . 'frontend/' . Mage::getDesign()->getPackageName() . '/' . Mage::getDesign()->getTheme('frontend') . '/images/logo_email.gif'
            , 'email_support' => Mage::getStoreConfig('trans_email/ident_support/email')
            , 'phone_support' => Mage::getStoreConfig('general/store_information/phone')
            , 'orden_fecha_hora' => $order->getCreatedAtFormated('long')
            , 'order_billing' => $order->getBillingAddress()->format('html')
            , 'clabe' => $vars['clabe']
            //, 'due_date' => $vars['due_date']
            , 'reference' => $vars['reference']
            , 'spei_monto' => $vars['spei_monto']
        );

        foreach ($campos AS $key => $value) {
            $talon = str_replace('{{' . $key . '}}', $value, $talon);
        }

        $fileHtml = $this->getPathHtml();

        if (1 == $this->_bitacoras) {
            $contenido = print_r($campos, TRUE);
            file_put_contents($this->_dirLog . 'Banwire_SPEI_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        if (1 == $this->_bitacoras) {
            $contenido = $fileHtml;
            file_put_contents($this->_dirLog . 'Banwire_SPEI_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        file_put_contents($fileHtml, $talon, 0);
    }

    /**
     * Genera el nombre y la ruta donde sera almacenada la imagen del codigo de barras.
     *
     * @return string
     */
    public function getPathHtml()
    {
        //return "$this->_path{$this->_params['referencia']}.png";
        return Mage::getBaseDir('media') . '/' . self::BANWIRE_SPEI_MEDIA_FOLDER . $this->_incrementId . '_' . $this->_response['clabe'] . '.html';
    }

    private function _getTelefonoCliente(& $quote)
    {
        $requestBilling = Mage::app()->getRequest()->getParam('billing');
        $billingAddress = $quote->getBillingAddress();

        $custWorkPhone = '00000';

        if (!isset($requestBilling['telephone'])) {
            //$this->getCustomer()->getPrimaryBillingAddress()->getTelephone();
            $custWorkPhone = substr($billingAddress->getTelephone(), 0, 19);
            if (5 > strlen($custWorkPhone)) {
                $custWorkPhone = '00000';
            }
        } else {
            $custWorkPhone = substr($requestBilling['telephone'], 0, 19);
        }

        $custWorkPhone = Mage::helper('banwirePro')->normalizarTelefono($custWorkPhone);
        if (5 > strlen($custWorkPhone)) {
            $custWorkPhone = '00000' . $custWorkPhone;
        }

        return $custWorkPhone;
    }

    private function _getArticulos()
    {
        # Fill var items
        $cartItems = Mage::getSingleton('checkout/session')->getQuote()->getAllItems();
        $aProducts = array();
        foreach ($cartItems as $item) {
            if ($item->getHasChildren()) {
                foreach ($item->getChildren() as $child) {
                    $priceCurrencyChild = $this->_setCurrencyAmount($child->getPrice());
                    $priceCurrencyItem = $this->_setCurrencyAmount($item->getPrice());

                    $priceItem = $priceCurrencyItem + $priceCurrencyChild;
                    $priceItemTotal = $item->getQty() * $priceItem;

                    $aDatos[] = array(
                        'quantity' => $item->getQty()
                        , 'unit_price' => number_format($priceItem, 2, '.', '') // Costo del artículo [X]  (Acepta hasta 2 decimales). 1-10
                        , 'amount' => number_format($priceItemTotal, 2, '.', '') // Costo total = Costo del artículo [X]  por la cantidad de artículos[X] (Acepta hasta 2 decimales). 1-10
                        , 'description' => substr($child->getName(), 0, 127) // Nombre o Descripción del articulo [X]. 5-127
                    );
                }
            } else {
                if (0 == (int) $item->getPrice()) {
                    continue;
                }

                $priceCurrency = $this->_setCurrencyAmount($item->getPrice());

                $aDatos[] = array(
                    'quantity' => $item->getQty() // Cantidad a comprar del articulo [X]. 1-8
                    , 'unit_price' => number_format($priceCurrency, 2, '.', '') // Costo del artículo [X]  (Acepta hasta 2 decimales). 1-10
                    , 'amount' => number_format($item->getQty() * $priceCurrency, 2, '.', '') // Costo total = Costo del artículo [X]  por la cantidad de artículos[X] (Acepta hasta 2 decimales). 1-10
                    , 'description' => substr($item->getName(), 0, 127) // Nombre o Descripción del articulo [X]. 5-127
                );
            }
        }

        $this->_params['items'] = $aDatos;
    }

    public function _setCurrencyAmount($amount)
    {
        $baseCurrencyCode = Mage::app()->getStore()->getBaseCurrencyCode();
        $currentCurrencyCode = Mage::app()->getStore()->getCurrentCurrencyCode();

        // convert price from current currency to base currency
        //$priceOne = Mage::helper('directory')->currencyConvert($price, $currentCurrencyCode, $baseCurrencyCode);
        // convert price from base currency to current currency
        $currencyAmount = Mage::helper('directory')->currencyConvert($amount, $baseCurrencyCode, $currentCurrencyCode);

        return $currencyAmount;
    }

}
